program define table3_dynan

* create a table showing statistics for the highly indebted
* versus others in 2007 
*

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table3_dynan_$mydate, replace
  capture log close

  file open myfile using "logfiles/table3_dynan_$mydate.txt", write replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
* drop if _n > 10000

* create the sample variables:  
*   1:  people who are in the sample every wave from 2005-2009

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1

  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=2007 | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 
  gen insamp = cons_samp
  local sss "Sample:  HHs in 2005, 2007, 2009 Waves"

  quietly gen group1 = (insamp==1) & (retsamp==0) & (hosamp==0)  
  quietly gen group2 = (insamp==1) & (retsamp==0) & (hosamp==1) & (boomsamp==0)
  quietly gen group3 = (insamp==1) & (retsamp==0) & (hosamp==1) & (boomsamp==1)

* generate changes

  local vlist d_to_y d_to_a mort_to_hv mort_to_y consxh_to_y networth_to_y nocars mvp_to_y ds_to_y 
  local vlist `vlist' consdbt_to_y adds_alts_to_y

  foreach ddd in 2 4 {
    foreach vvv in `vlist' {
      quietly gen d`ddd'`vvv' = `vvv' - l`ddd'.`vvv'
    }
  }

* generate percent changes

  foreach zzz in 2 4 {
    foreach vvv in consxh_aa myprev hsval tot_fin mort_bal veh_bal_amt oth_dbt networth  {
       quietly gen z`zzz'`vvv' = 100*(`vvv' - l`zzz'.`vvv') / l`zzz'.`vvv'
       quietly replace z`zzz'`vvv' = 100 if z`zzz'`vvv' > 100 & z`zzz'`vvv' ~= . 
       quietly replace z`zzz'`vvv' = -100 if z`zzz'`vvv' < -100 & z`zzz'`vvv' ~= . 
       quietly replace z`zzz'`vvv' = 0 if `vvv'==0 & l`zzz'.`vvv'==0
    }
  }

* generate indicator of someone who became a homeowner

  foreach ddd in 2 4 {
    quietly gen new_ho_`ddd' = homeown - l`ddd'.homeown
    quietly replace new_ho_`ddd' = 0 if new_ho_`ddd' < 0
  } 

* generate indicator of someone who exited homeownership

  quietly gen exit_ho_2 = (homeown==0) & (l2.homeown==1)

* divide income, consumption, and wealth by 1000

  foreach vvv in myprev consxh_aa networth hsval tot_fin mort_bal veh_bal oth_dbt cons_dbt adds_alts {
     quietly replace `vvv' = `vvv'/1000
  }

* mortgage distress stats

  quietly gen dist_v_likely = mort_dist_prob_1==1 | mort_dist_prob_2==1 ///
                            if mort_dist_prob_1~=. & mort_dist_prob_2~=.

  quietly gen dist_s_likely = mort_dist_prob_1==3 | mort_dist_prob_2==3 ///
                            if mort_dist_prob_1~=. & mort_dist_prob_2~=.

  foreach vvv in mort_beh_yes mort_fc_yes mort_mod {
    forvalues nnn = 1/2 {
      quietly replace `vvv'_`nnn' = (`vvv'_`nnn'==1) if `vvv'_`nnn'~=.
    }
  }

  quietly gen mort_beh_yes = mort_beh_yes_1 == 1 | mort_beh_yes_2 == 1
  quietly gen mort_fc_yes  = mort_fc_yes_1 == 1 | mort_fc_yes_2 == 1
  quietly gen mort_mod     = mort_mod_1 == 1 | mort_mod_2 == 1



* TABLE 

  local rowlist z2myprev d2nocars z2consxh_aa d2consxh_to_y d2networth_to_y d2mort_to_y d2mort_to_hv d2consdbt_to_y
  local rowlist `rowlist' d2ds_to_y moved_yes exit_ho_2
  local rowlist `rowlist' mort_beh_yes mort_fc_yes mort_mod dist_s_likely dist_v_likely
  local rowlist `rowlist' z2state_hpi state_ur
	 
  local r1  "Change 2007-2009:"
  local r2  "  Income[t-1] (%)"
  local r3  "  # of vehicles*"
  local r4  "  Nonhous C (%)"
  local r5  "  Nonhous C/Y"
  local r6  "  NW/Y" 
  local r7  "  Mortgage/Y"
  local r8  "  Mortgage/house value"
  local r9  "  Consumer debt/y"
  local r10 "  DS/Y"
  local r11 "  Moved*"
  local r12 "  Exited homeownership*"
  local r13 "2009 values:"
  local r14 "  Behind on mort*"
  local r15 "  FC started*"
  local r16 "  Mort mod*"
  local r17 "  S likely to fall beh*"
  local r18 "  V likely to fall beh*"
  local r19 "2009 Characteristics of 2007 State of Residence"
  local r20 "  %ch HPI 07-09"
  local r21 "  State UR"
  local r22 "Number of observations"

     file write myfile _column(23) "                    Table 3" _n
     file write myfile _column(23) "Comparison between Households who were Highly Indebted" _n
     file write myfile _column(23) "      and Others After the Peak of the Credit Boom" _n
     file write myfile _column(23) "   `sss'" _n _n
 
     file write myfile %-20s "     " ///
      _column(29) "Non-homeowners" ///
      _column(47) "  Homeowners" ///
      _column(65) "  Homeowners" /// 
      _n

      file write myfile %-20s "     " ///
      _column(34) " " ///
      _column(46) "In Non-boom States" ///
      _column(64) " In Boom States" /// 
      _n 

      file write myfile %-20s "     " ///
      _column(28) "----------------" ///
      _column(46) "----------------" ///
      _column(64) "----------------" /// 
      _n 

     file write myfile %-20s "     " ///
      _column(28) "High-Debt" ///
      _column(36) "  Other" ///
      _column(46) "High-Debt" ///
      _column(54) "  Other" ///
      _column(64) "High-Debt" ///
      _column(72) "  Other" ///
     _n _n


     * Two panels:  top quintiles of D/A and DS/Y

       forvalues ppp = 1/2 {
         
         if `ppp' == 1 {
		quietly gen vgroup1 = d_to_a
		quietly gen vgroup2 = mort_to_hv
		quietly gen vgroup3 = mort_to_hv
		file write myfile %-20s "  " ///
                  _column(28) "-- Based on Traditional Measure of Leverage D07/A07 --" _n 
         }
	   if `ppp' == 2 {
		quietly gen vgroup1 = ds_to_l2y
		quietly gen vgroup2 = ds_to_l2y
		quietly gen vgroup3 = ds_to_l2y
		file write myfile  %-20s "  " ///
                  _column(28) "      -- Based on Debt Service Burden DS07/Y05 --" _n 
          }
         * create top quintiles
           foreach ggg in group1 group2 group3 {
             quietly _pctile v`ggg' if yr == 2007 & v`ggg' ~=. & `ggg'==1 [w=wgt], percentiles(80)
             quietly gen tq`ggg' = (v`ggg' >= r(r1)) if yr == 2007 & v`ggg' ~=. & `ggg'==1
             quietly gen oh`ggg' = (v`ggg' < r(r1)) if yr == 2007 & v`ggg' ~=. & `ggg'==1 
           }
           local nnn = 1
           file write myfile %-20s "`r`nnn''" _n 
           local nnn = 2
           foreach rrr in `rowlist' {
              local stat p50
              if inlist("`rrr'","d2nocars","mort_beh_yes","mort_fc_yes","mort_mod") {
                 local stat mean
               } 
              if inlist("`rrr'","dist_v_likely","dist_s_likely","moved_yes","exit_ho_2") {
                 local stat mean
               } 
 
              foreach ggg in group1 group2 group3 {
                 quietly summ `rrr' [w=wgt] if yr==2009 & l2.tq`ggg'==1, detail
                 scalar tq`ggg'_stat = r(`stat')
                 quietly summ `rrr' [w=wgt] if yr==2009 & l2.oh`ggg'==1, detail
                 scalar oh`ggg'_stat = r(`stat')
              }
              file write myfile %-20s "`r`nnn''" ///
                _column(28) %8.2f (tqgroup1_stat)  ///
                _column(36) %8.2f (ohgroup1_stat) ///
                _column(46) %8.2f (tqgroup2_stat)  ///
                _column(54) %8.2f (ohgroup2_stat) ///
                _column(64) %8.2f (tqgroup3_stat)  ///
                _column(72) %8.2f (ohgroup3_stat) ///
                _n
             if inlist(`nnn',12,18) {
                file write myfile _n
                local nnn = `nnn' + 1
                file write myfile %-20s "`r`nnn''" _n
             }
             local nnn = `nnn'+1
          }
   
          foreach ggg in group1 group2 group3 {
            quietly summ hage [w=wgt] if yr==2009 & l2.tq`ggg'==1 
            scalar tq`ggg'_num = r(N)
            quietly summ hage [w=wgt] if yr==2009 & l2.oh`ggg'==1
            scalar oh`ggg'_num = r(N)
          }
	   file write myfile _n
	   file write myfile %-20s "`r`nnn''" ///
	     _column(28) %8.0f (tqgroup1_num)  ///
	     _column(36) %8.0f (ohgroup1_num) ///
	     _column(46) %8.0f (tqgroup2_num)  ///
	     _column(54) %8.0f (ohgroup2_num) ///
	     _column(64) %8.0f (tqgroup3_num)  ///
	     _column(72) %8.0f (ohgroup3_num) ///
	    _n _n

          drop tq* oh* vgroup* 
          }
   file write myfile _n
   file write myfile %-100s "Means shown for variables marked with a *; all other statistics are medians." _n 
   file write myfile %-100a "High debt households (traditional measure) are those in highest quintile of" _n
   file write myfile %-100a "D/A for non-homeowners and of Mortgage/House Value for homeowners." _n
   file write myfile %-100a "High debt burden households are based on total debt service 07/income 05." _n
   file write myfile %-100s "Sample includes only households with a full set of interviews 2005-2009. " _n 
   file write myfile %-100s _n "newpage" _n _n 

  
file close myfile

capture log close

end
